' RedMaker - a program that evolves core-warriors
' (c) 1998-2004 Terry Newton (wtnewton@infionline.net)
' http://www.infionline.net/~wtnewton/corewar/evol/
'
' Version 2.91 last change Dec 27 2004
' This is a qbasic program for msdos, requires qbasic.exe to run source
' Compiles to ~75K EXE with Powerbasic's "First Basic" compiler (no gr)
' Compiles to ~95K EXE with MS QuickBasic 4.5
'
' Requires PMARS.EXE and PMARSV.EXE 'on the path' or in the
' current directory, see http://www.koth.org/ for software and
' corewar information. Calls EDIT to edit the warrior used for
' birth testing, default test.war contains jmp 0. Put benchmark
' warriors in current directory or specify a wildcard mask.
' Evolved warriers are created in the 'warcode' directory.
' Variables in 'redmaker.def', delete to restore defaults.
'
' Distributed under terms of the GNU General Public Licence
' GPL online at: http://www.fsf.org/licenses/gpl.html
'
progid$ = "RedMaker 2.91"
copyrt$ = "GPL (c) 1998-2004 Terry Newton"
twiceopt = 1 'new 2.8 - battle twice with positions reversed
replaceloser = 1 'new 2.81 - replicate to positions vacated by win
extrainfo = 2 'new 2.83 - write extra generation info to warriors
enableredmix = 1 'new 2.83 - crossover? experimental.
mixcourseness = .5  'average size of the chunks compared to warrior size
coreview = 0 'new 2.84.. view by 0=species 1=battles 2=length
 '(new for 2.9) 3=score/10 4=(last 2 digits of) gen and 5=gen/100
colorby = 1  'color by 0=species 1=data (v2.9) 2=no color
autostart = 0  'evolve on startup
adjustrefs = 0 'new 2.85 0=off 1=on 2=sometimes
'rm2.9 - new features... if battle stats (all) enabled, creates
'a directory to save warriors that perform well. From time to time
'these are introduced. New interface options to control...
savedir$ = "warsave"  'directory (from current) to save warriors to
savethresh = 10    'save warrior if it survives this many or more battles
reintrochance = .005  'chance of reintroducing randomly selected saved copy
savelimit = 50     '(approx) max number of saved warriors
pruneiter = 1000   'check every n iterations
enreintro = 0  'enable/disable reintro feature
stopcheck = 10  'check del2stop file every n iterations (0 to disable)
SHELL "break off" '9-18-01 try to avoid ctrl-c bug

'original default parms (last changed 12-26-04)
gridsize = 21              '21 max, produces up to n^2 warriors
maxlen = 20                'maximum warrior length
coresize = 800             'target core size
processes = 800            'maximum processes
cycles = 8000              'instruction cycles per round
rounds = 20                'rounds per battle 33 max
perfect = .05               'chance of perfect copy
change = .05                'overall chance of change per line
datachange = 1             'individual chances, each start with
adrchange = 1              ' 1/4 of the opportunities to change
instrchange = 1            ' if change=.2 and datachange=.5 then
sizechange = 1             ' actual chance=.025 (.2/4 * .5)
localnum = .6              'chance constants are within warsize
localvar = .15             'per cycle variation from localnum chance
tragedy = .3               'chance of "accident" if tie
startdensity = .75         'starting population density
minscore = 95              'start value for minimum survival score
maxscore = 110             'max value for minimum survival score
adjrate = 300              'increase msc by 1 every n cycles
remloser = 1               '0 or 1, remove loser (otherwise only if < mss)
teststart = 0              '0 or 1, test initial population members
testbirth = 0              '0 or 1, test new birth members
testrounds = 5             'evaluation rounds when testing new members
testdelay = 3000           'n iterations before testing (if not teststart)
testscore = 300            'minimum score when testing
pmars$ = "pmars -b"        'pmars command (add dir if not on path)
wardir$ = "warcode"        'directory to place evolved warriors
savefile$ = "redmaker.dat" 'data save file, iteration and mss (in wardir)
reddefs$ = "redmaker.def"  'data save file for parameters (in prg dir)
pmarsv$ = "pmarsv -b"      'command for visually running warrior
grmode$ = "-v 414"         'pmarsv graphics parm
txmode$ = "-v 404"         'text parm
usegraphics = 0            '0 for textmode, 1 for graphics
listprg$ = ""              'external lister (if not empty)

' settings for testing warriors manually from menu
' as written looks for red files in current directory
' for info only, not used to guide evolution (see below for that)
mtmask$ = "*.red"            'mask of redcode to test with
mtpmars$ = "pmars -b"        'pmars command when testing
mtrounds = 200               'rounds when testing
mtbase$ = "temp$tst"         'base name for temp files
' set this to use an external recode tester
' passes the filename to test as the first parm
mtexttest$ = ""

' redcode to optionally influence evolution
' if testbirth or teststart = 1 new members must beat this
testwar$ = "test.war"           'test warrior, creates if not found
testwarlen = 1                  'default test warrior length
testwarline$(1) = "jmp 0"

'weighed instructions...
DATA 25,dat,dat,dat,mov,mov,mov,mov,mov,spl,spl,spl,spl,jmp,jmp
DATA jmn,jmz,djn,add,sub,slt,sne,seq,mod,mul,div
DATA 18,a,b,ab,ba,f,f,f,x,x,x,i,i,i,i,i,i,i,i
DATA 8,#,$,@,*,<,>,{,}

maxnins = 100: maxnmod = 50: maxnadr = 50

' initialize data arrays
maxwarlines = 100: DIM textbuffer$(maxwarlines)  'for listing redcode
cx = 1: cy = 1: gridvalid = 0: isx = 1: isy = 1
READ nins: DIM instructs$(100)
FOR i = 1 TO nins: READ instructs$(i): NEXT i
READ nmod: DIM modifiers$(50)
IF nmod > 0 THEN FOR i = 1 TO nmod: READ modifiers$(i): NEXT i
READ nadr: DIM adrmodes$(50)
FOR i = 1 TO nadr: READ adrmodes$(i): NEXT i

DIM grid$(21, 21), warlength%(21, 21), warbattles%(21, 21)
DIM coreviewname$(5): coreviewname$(0) = "species"
coreviewname$(1) = "battles": coreviewname$(2) = "length"
coreviewname$(3) = "score/10": coreviewname$(4) = "gen"
coreviewname$(5) = "gen/100"
DIM warscore%(21, 21), wargen%(21, 21)

' load default file if one exists
ON ERROR GOTO nodeffile
OPEN reddefs$ FOR INPUT AS #1
ON ERROR GOTO shortfile
INPUT #1, minscore, maxscore, adjrate, remloser, change, perfect, tragedy
INPUT #1, rounds, usegraphics, mtrounds, mtmask$, teststart, testbirth
INPUT #1, testdelay, testscore, testrounds, testwar$, startdensity
INPUT #1, nins: FOR i = 1 TO nins: INPUT #1, instructs$(i): NEXT i
INPUT #1, nmod
IF nmod > 0 THEN FOR i = 1 TO nmod: INPUT #1, modifiers$(i): NEXT i
INPUT #1, nadr: FOR i = 1 TO nadr: LINE INPUT #1, adrmodes$(i): NEXT i
INPUT #1, localnum, localvar, datachange, sizechange, adrchange
INPUT #1, instrchange, gridsize, maxlen, coresize, cycles, processes
INPUT #1, pmars$, pmarsv$, mtpmars$, grmode$, txmode$, twiceopt
INPUT #1, replaceloser, extrainfo, enableredmix, mixcourseness
INPUT #1, coreview, colorby, autostart, wardir$, adjustrefs
INPUT #1, enreintro, savethresh, reintrochance, savedir$, savelimit
GOTO finishinit
shortfile:
RESUME finishinit
finishinit:
CLOSE #1

GOSUB validatedata
IF baddata THEN
 PRINT "Bad data in "; reddefs$; " file - correct or delete"
 SYSTEM
END IF
RANDOMIZE TIMER
txto = gridsize * 2 + 8
rerun = 0: iteration& = 0: dobirthchecks = 0: mss = minscore
somethingthere = 0 '12/27/04 don't reintroduce until something saved
GOSUB checktestwar

' check for existence of wardir
checkwardir:
'12/26/04 can't assume nul devices, breaks with XP/NT and FreeDos
'instead see if redmaker.dat exists...
ON ERROR GOTO nowarerr
a$ = wardir$ + "\redmaker.dat": OPEN a$ FOR INPUT AS #1
CLOSE #1

' wardir exists, check for restart file
ON ERROR GOTO norestartfile
a$ = wardir$ + "\restart.dat"
OPEN a$ FOR INPUT AS #1: INPUT #1, isx, isy
CLOSE #1: KILL a$: GOTO initstart

' errorhandlers
nodeffile:
RESUME finishinit
norestartfile:
CLOSE : RESUME startevol
nowarerr:
CLOSE : RESUME initstart
initerror:
CLOSE : RESUME saverestart
saverestart:
PRINT : PRINT : PRINT "Writing restart file..."
ON ERROR GOTO hardquit
KILL redfile$: a$ = wardir$ + "\restart.dat"
OPEN a$ FOR OUTPUT AS #1: PRINT #1, x, y
hardquit:
CLOSE : SYSTEM
nodatafile:
RESUME cdfdone
fswnoscore:
CLOSE : RESUME menu
menuerror:
CLOSE : PRINT "Error "; ERR; " at "; ERL: SYSTEM
reproerror:
RESUME rperror1
rperror1:
ON ERROR GOTO 0
CLOSE : CLS
PRINT "Repro error, deleting "; zname$; " "; newzname$
SHELL "del " + redfile$
SHELL "del " + opponent$
PRINT "Error "; ERR; " at "; ERL
INPUT "Continue? ", a$
IF LCASE$(a$) = "y" GOTO menu
SYSTEM

' here if invalid score from pressing ctrl-c in pmars
menu:
ON ERROR GOTO menuerror
IF stopcheck > 0 THEN
 SHELL "if exist del2stop del del2stop"
END IF
GOSUB plotwarriors
COLOR 4, 0: LOCATE 3, txto: PRINT progid$
COLOR 7, 0: LOCATE 6, txto: PRINT "File:"
LOCATE 7, txto: PRINT "Iteration:"; iteration&
LOCATE 9, txto: PRINT "1-9) Battle opponent"
LOCATE 10, txto: PRINT "R) Run warrior"
LOCATE 11, txto: PRINT "L) List warrior"
LOCATE 12, txto: PRINT "B) Benchmark warrior"
LOCATE 13, txto: PRINT "D) Delete warrior"
LOCATE 14, txto: PRINT "E) Evolve warriors"
LOCATE 15, txto: PRINT "U) Update display"
LOCATE 16, txto: PRINT "P) Parameters"
LOCATE 17, txto: PRINT "V) View by "; coreviewname$(coreview)
LOCATE 18, txto: PRINT "C) Color ";
IF colorby = 0 THEN PRINT "by species"
IF colorby = 1 THEN PRINT "by data"
IF colorby = 2 THEN PRINT "off"
LOCATE 19, txto: PRINT "Q) Quit"
keyloop:
f$ = CHR$(64 + cx) + CHR$(64 + cy) + ".RED"
LOCATE 6, txto + 6, 0: PRINT f$;
LOCATE cy + 2, cx * 2 + 2, 1, 0, 31
getkey:
a$ = INKEY$: IF a$ = "" GOTO getkey
k = 0: IF LEN(a$) = 2 THEN k = ASC(RIGHT$(a$, 1))
IF k = 72 THEN cy = cy - 1: IF cy < 1 THEN cy = gridsize
IF k = 80 THEN cy = cy + 1: IF cy > gridsize THEN cy = 1
IF k = 75 THEN cx = cx - 1: IF cx < 1 THEN cx = gridsize
IF k = 77 THEN cx = cx + 1: IF cx > gridsize THEN cx = 1
IF NOT k = 0 GOTO keyloop
LOCATE , , , 31, 31 'put cursor back to normal
a$ = LCASE$(a$)
IF a$ = "q" GOTO getoutofhere
IF a$ = "p" GOTO parameters
IF a$ = "e" GOTO evolve
IF a$ = "u" GOTO refresh
IF a$ = "v" THEN
 coreview = coreview + 1
 IF coreview > 5 THEN coreview = 0
 GOTO menu
END IF
IF a$ = "c" THEN
 colorby = colorby + 1
 IF colorby > 2 THEN colorby = 0
 GOTO menu
END IF
f$ = wardir$ + "\" + f$
ON ERROR GOTO nofilehere
OPEN f$ FOR INPUT AS #1: CLOSE
ON ERROR GOTO menuerror
IF a$ = "l" GOTO listwarrior
IF a$ = "r" GOTO runwarrior
IF a$ = "b" GOTO testwarrior
IF a$ = "d" GOTO deletewarrior
'new battle options 8/26/00 2.82
IF a$ >= "1" AND a$ <= "9" GOTO runagainst
GOTO keyloop
nofilehere:
CLOSE : RESUME keyloop
refresh:
gridvalid = 0: GOTO menu

runwarrior:
CLS
comnd$ = pmarsv$ + " -s" + STR$(coresize) + " -c"
comnd$ = comnd$ + STR$(cycles) + " -p" + STR$(processes)
IF usegraphics THEN comnd$ = comnd$ + " " + grmode$
IF usegraphics = 0 THEN comnd$ = comnd$ + " " + txmode$
SHELL comnd$ + " " + f$: GOTO menu

'new 8/26/00 run warrior against opponent
'a$ = "1" to "9" to indicate direction, 5 runs against self
runagainst:
IF a$ = "1" THEN zx = cx - 1: zy = cy + 1
IF a$ = "2" THEN zx = cx: zy = cy + 1
IF a$ = "3" THEN zx = cx + 1: zy = cy + 1
IF a$ = "4" THEN zx = cx - 1: zy = cy
IF a$ = "5" THEN zx = cx: zy = cy
IF a$ = "6" THEN zx = cx + 1: zy = cy
IF a$ = "7" THEN zx = cx - 1: zy = cy - 1
IF a$ = "8" THEN zx = cx: zy = cy - 1
IF a$ = "9" THEN zx = cx + 1: zy = cy - 1
IF zx < 1 THEN zx = gridsize
IF zx > gridsize THEN zx = 1
IF zy < 1 THEN zy = gridsize
IF zy > gridsize THEN zy = 1
o$ = wardir$ + "\" + CHR$(64 + zx) + CHR$(64 + zy) + ".RED"
ON ERROR GOTO nofilehere
OPEN o$ FOR INPUT AS #1: CLOSE
CLS : LOCATE 3, 1: PRINT f$; " vs "; o$: PRINT
comnd$ = pmarsv$ + " -s" + STR$(coresize) + " -c"
comnd$ = comnd$ + STR$(cycles) + " -p" + STR$(processes)
IF usegraphics THEN comnd$ = comnd$ + " " + grmode$
IF usegraphics = 0 THEN comnd$ = comnd$ + " " + txmode$
SHELL comnd$ + " " + f$ + " " + o$
LOCATE 23, 1: PRINT "-- press any key --"
WHILE INKEY$ = "": WEND
GOTO menu

deletewarrior:
LOCATE 21, txto: PRINT "Confirm Delete"
LOCATE cy + 2, cx * 2 + 2, 1, 0, 31
dwkey:
a$ = LCASE$(INKEY$): IF a$ = "" GOTO dwkey
IF a$ = "y" THEN KILL f$
GOTO refresh

listwarrior:
IF NOT listprg$ = "" GOTO extlister
CLS : i = 0: OPEN f$ FOR INPUT AS #1
WHILE (NOT EOF(1) AND i < maxwarlines)
 i = i + 1: LINE INPUT #1, a$
 textbuffer$(i) = LEFT$(a$ + SPACE$(79), 79)
WEND: CLOSE #1: j = 1
listloop:
LOCATE 1, 1, 0: FOR ln = j TO j + 22
IF ln <= i THEN PRINT textbuffer$(ln)
NEXT ln
IF ln <= i THEN PRINT "--- up/down to scroll ---";  ELSE PRINT SPACE$(25);
lkloop:
a$ = INKEY$: k = 0: IF LEN(a$) = 2 THEN k = ASC(RIGHT$(a$, 1))
IF k = 72 AND j > 1 THEN j = j - 1: GOTO listloop
IF k = 80 AND ln <= i THEN j = j + 1: GOTO listloop
IF a$ = CHR$(27) THEN GOTO menu ELSE GOTO lkloop
extlister:
CLS : SHELL listprg$ + " " + f$: GOTO menu

testwarrior:
IF NOT mtexttest$ = "" GOTO exttester
' this requires batch processing, assumes dos 5 or better
CLS : PRINT : PRINT "Testing redcode... (don't press any keys)"
OPEN mtbase$ + ".bat" FOR OUTPUT AS #1
PRINT #1, "@echo off"
PRINT #1, "if not .%1==. goto process"
PRINT #1, "if exist "; mtbase$; ".out del "; mtbase$; ".out"
PRINT #1, "for %%a in ("; mtmask$; ") do call %0 %%a"
PRINT #1, "goto done"
PRINT #1, ":process"
PRINT #1, "echo "; f$; " vs %1"
PRINT #1, mtpmars$; " -s"; coresize; " -c"; cycles; " -p"; processes;
PRINT #1, " -r"; mtrounds; " "; f$; " %1>>"; mtbase$; ".out"
PRINT #1, ":done"
CLOSE #1: SHELL mtbase$ + ".bat": KILL mtbase$ + ".bat"
' determine warrior name
OPEN f$ FOR INPUT AS #1: zname$ = ""
WHILE (NOT EOF(1) AND zname$ = "")
 LINE INPUT #1, a$
 IF LEFT$(a$, 6) = ";name " THEN zname$ = RIGHT$(a$, LEN(a$) - 6)
WEND: CLOSE #1
' tally up the scores, ripped from my testwar batch
ts = 0: no = 0: ON ERROR GOTO mtnoscore
OPEN mtbase$ + ".out" FOR INPUT AS #1: CLS : PRINT
PRINT "Opponent         Scores    Results    Performance of "; zname$
PRINT "--------         ------    -------    ---------=---------=---------=---------="
mtL:
IF EOF(1) GOTO mtX
LINE INPUT #1, a$: IF INSTR(a$, "scores ") = 0 GOTO mtL
LINE INPUT #1, b$: LINE INPUT #1, c$: IF INSTR(a$, zname$) = 0 GOTO mtL
w$ = LEFT$(b$, INSTR(b$, " by "))
w$ = LEFT$(w$ + "               ", 15) + " "
ms = VAL(RIGHT$(a$, LEN(a$) - INSTR(a$, "scores ") - 6)): ts = ts + ms
os = VAL(RIGHT$(b$, LEN(b$) - INSTR(b$, "scores ") - 6)): no = no + 1
ms$ = LEFT$(STR$(ms) + "   ", 4): os$ = LEFT$(STR$(os) + "   ", 4)
re$ = RIGHT$(c$, LEN(c$) - 8): re$ = LEFT$(re$ + "            ", 12)
PRINT w$; os$; ms$; "  "; re$; : IF os + ms = 0 OR ms = 0 GOTO mtN
ra = (ms / (mtrounds * 3)) * 40: FOR z = 1 TO ra: PRINT "*"; : NEXT z
mtN:
PRINT : GOTO mtL
mtX:
CLOSE #1
PRINT "--------         ------    -------    ---------=---------=---------=---------="
KILL mtbase$ + ".out"
IF no > 0 THEN PRINT "Adjusted Score:"; INT(((ts / no) / (mtrounds / 100)) * 10) / 10;
mtestend:
PRINT "  (press any key)";
WHILE INKEY$ = "": WEND
GOTO menu
mtnoscore:
CLOSE : PRINT "No scores, check test directory": RESUME mtestend
exttester:
CLS : SHELL mtexttest$ + " " + f$: GOTO mtestend

parameters:
ON ERROR GOTO menuerror
CLS : PRINT
PRINT "     Iteration ="; iteration&; "  Current survival score ="; mss
PRINT
PRINT "     A) Minimum survival score "; minscore
PRINT "     B) Maximum survival score "; maxscore
PRINT "     C) Score adjust interval  "; adjrate
PRINT "     D) Always remove loser     ";
IF remloser THEN PRINT "Yes" ELSE PRINT "No"
PRINT "     E) Replace removed loser   ";
IF replaceloser THEN PRINT "Yes" ELSE PRINT "No"
PRINT "     F) Red-mix mode            ";
IF enableredmix = 0 THEN PRINT "Off"     '3-4-01
IF enableredmix = 1 THEN PRINT "Same"
IF enableredmix = 2 THEN PRINT "Any"  'new redmix option to mix all
PRINT "     G) Line change rate       "; change
PRINT "     H) Perfect copy rate      "; perfect
PRINT "     I) Remove tie rate        "; tragedy
PRINT "     J) Pmarsv mode             ";
IF usegraphics THEN PRINT "Graphics" ELSE PRINT "Text"
PRINT "     K) Benchmark rounds       "; mtrounds
PRINT "     L) Benchmark warriors      "; mtmask$
PRINT
PRINT "     1) Start/eval options"
PRINT "     2) Instruction options"
PRINT "     3) Other options"
PRINT "     4) Save as defaults"
PRINT
PRINT "     Press Esc when done"
PRINT
pkeyloop:
a$ = LCASE$(INKEY$)
IF a$ = "a" THEN INPUT "Minimum score"; minscore: GOTO parameters
IF a$ = "b" THEN INPUT "Maximum score"; maxscore: GOTO parameters
IF a$ = "c" THEN INPUT "Adjustment interval"; adjrate: GOTO parameters
IF a$ = "d" THEN remloser = 1 - remloser: GOTO parameters
IF a$ = "e" THEN replaceloser = 1 - replaceloser: GOTO parameters
IF a$ = "f" THEN
 enableredmix = enableredmix + 1   '3-4-01
 IF enableredmix > 2 THEN enableredmix = 0
 GOTO parameters
END IF
IF a$ = "g" THEN INPUT "Line change rate (0-1)"; change: GOTO parameters
IF a$ = "h" THEN INPUT "Perfect rate (0-1)"; perfect: GOTO parameters
IF a$ = "i" THEN INPUT "Tie removal rate (0-1)"; tragedy: GOTO parameters
IF a$ = "j" THEN usegraphics = 1 - usegraphics: GOTO parameters
IF a$ = "k" THEN INPUT "Test rounds"; mtrounds: GOTO parameters
IF a$ = "l" THEN INPUT "Test filemask"; mtmask$: GOTO parameters
IF a$ = "1" GOTO evaloptions
IF a$ = "2" GOTO instructoptions
IF a$ = "3" GOTO otheroptions
IF a$ = "4" THEN
 GOSUB savesettings
 IF baddata GOTO baddatamessage
 GOTO menu
END IF
IF a$ = CHR$(27) THEN
 GOSUB validatedata
 IF baddata THEN
baddatamessage:
  PRINT "Error in data, correct before proceeding"
  GOSUB pressanykey: GOTO parameters
 END IF
 GOTO menu
END IF
GOTO pkeyloop

evaloptions:
CLS : PRINT
PRINT "     A) Start Density           "; startdensity
PRINT "     B) Start Testing            ";
IF teststart THEN PRINT "On" ELSE PRINT "Off"
PRINT "     C) Birth Testing            ";
IF testbirth THEN PRINT "On" ELSE PRINT "Off"
PRINT "     D) Extra info in comments   ";
IF extrainfo = 0 THEN PRINT "Off"
IF extrainfo = 1 THEN PRINT "Some"
IF extrainfo = 2 THEN PRINT "All"
PRINT "     E) Delay before testing    "; testdelay
PRINT "     F) Required test score     "; testscore
PRINT "     G) Rounds for test         "; testrounds
PRINT "     H) Test warrior file        "; testwar$
PRINT "     I) Soup directory           "; wardir$
PRINT "     J) Evolve upon running      ";
IF autostart = 0 THEN PRINT "No" ELSE PRINT "Yes"
IF extrainfo = 2 THEN
 PRINT "     K) Save/Re-intro            ";
 IF enreintro THEN PRINT "On" ELSE PRINT "Off"
 IF enreintro THEN
  PRINT "     L) Save threshold          "; savethresh
  PRINT "     M) Re-intro chance         "; reintrochance
  PRINT "     N) Save directory           "; savedir$
  PRINT "     O) Max saved warriors      "; savelimit
 END IF
END IF
PRINT
PRINT "     1) Edit test warrior"
PRINT "     2) Run test warrior"
PRINT "     3) Begin new population"
PRINT
PRINT "     Press Esc when done"
PRINT
evalo2:
a$ = LCASE$(INKEY$)
IF a$ = "a" THEN INPUT "Start density (0-1)"; startdensity: GOTO evaloptions
IF a$ = "b" THEN teststart = 1 - teststart: GOTO evaloptions
IF a$ = "c" THEN testbirth = 1 - testbirth: GOTO evaloptions
IF a$ = "d" THEN
 extrainfo = extrainfo + 1
 IF extrainfo > 2 THEN extrainfo = 0
 GOTO evaloptions
END IF
IF a$ = "e" THEN INPUT "Delay before testing"; testdelay: GOTO evaloptions
IF a$ = "f" THEN INPUT "Required test score (max 300)"; testscore: GOTO evaloptions
IF a$ = "g" THEN INPUT "Rounds per test (max 33)"; testrounds: GOTO evaloptions
IF a$ = "h" THEN INPUT "Test warrior file"; testwar$: GOTO evaloptions
IF a$ = "i" THEN
 b$ = wardir$: INPUT "Soup directory (saves and restarts)"; wardir$
 wardir$ = LTRIM$(RTRIM$(wardir$))
 IF wardir$ <> "" THEN
  GOSUB savesettings: IF baddata = 0 THEN RUN
  PRINT "Bad data.. can't restart": GOSUB pressanykey
 END IF
 wardir$ = b$: GOTO evaloptions
END IF
IF a$ = "j" THEN autostart = 1 - autostart: GOTO evaloptions

IF extrainfo = 2 THEN
 IF a$ = "k" THEN enreintro = 1 - enreintro: GOTO evaloptions
 IF enreintro THEN
  IF a$ = "l" THEN INPUT "Save threshold"; savethresh: GOTO evaloptions
  IF a$ = "m" THEN INPUT "Re-intro chance"; reintrochance: GOTO evaloptions
  IF a$ = "n" THEN INPUT "Save directory"; savedir$: GOTO evaloptions
  IF a$ = "o" THEN INPUT "Max saved warriors (0 for no limit)"; savelimit: GOTO evaloptions
 END IF
END IF

IF a$ = "1" THEN SHELL "EDIT " + testwar$: GOTO evaloptions
IF a$ = "2" THEN GOTO runtestwarrior
IF a$ = "3" GOTO reinitialise
IF a$ <> CHR$(27) GOTO evalo2
GOTO parameters

reinitialise:
GOSUB savesettings
IF baddata GOTO baddatamessage
PRINT "Delete warriors and restart? ";
b$ = "": WHILE (b$ = ""): b$ = LCASE$(INKEY$): WEND
IF b$ <> "y" GOTO evaloptions
reinit1:
IF wardir$ = "" THEN PRINT "Wardir$ error": SYSTEM
OPEN mtbase$ + ".bat" FOR OUTPUT AS #1
PRINT #1, "@echo off" 'ok a bit safer...
PRINT #1, "for %%a in ("; wardir$; "\*.red) do del %%a"
PRINT #1, "for %%a in ("; wardir$; "\*.r) do del %%a"
PRINT #1, "for %%a in ("; wardir$; "\re*.dat) do del %%a"
PRINT #1, "for %%a in ("; wardir$; "\re*.def) do del %%a"
PRINT #1, "rd "; wardir$
CLOSE #1
SHELL mtbase$ + ".bat"
KILL mtbase$ + ".bat"
RUN

runtestwarrior:
CLS
comnd$ = pmarsv$ + " -s" + STR$(coresize) + " -c"
comnd$ = comnd$ + STR$(cycles) + " -p" + STR$(processes)
IF usegraphics THEN comnd$ = comnd$ + " " + grmode$
IF usegraphics = 0 THEN comnd$ = comnd$ + " " + txmode$
SHELL comnd$ + " " + testwar$
GOSUB pressanykey: GOTO evaloptions

instructoptions:
CLS : PRINT
PRINT : PRINT "   1) Instructions: ";
FOR i = 1 TO nins: j = (i - 1) / 12: IF j = 0 THEN j = .1 '???? fiiw :)
IF j = INT(j) THEN PRINT : PRINT SPACE$(20);
PRINT instructs$(i); " "; : NEXT i: PRINT
PRINT : PRINT "   2) Modifiers: ";
IF nmod > 0 THEN FOR i = 1 TO nmod: PRINT modifiers$(i); " "; : NEXT i
PRINT : PRINT : PRINT "   3) Address modes :";
FOR i = 1 TO nadr: PRINT adrmodes$(i); " "; : NEXT i: PRINT
PRINT
PRINT "   Choose from..."
PRINT
PRINT "   Instructions:  dat nop mov spl jmz jmn jmp djn add sub"
PRINT "                  cmp slt sne seq mod mul div ldp stp"
PRINT "   Modifiers:     a b ab ba f x i   (or none)"
PRINT "   Address Modes: # $ @ * < > { }"
PRINT
PRINT "   Note... no error checking!"
PRINT
PRINT "   Press Esc when done"
PRINT
modin1:
a$ = INKEY$: IF a$ = CHR$(27) GOTO parameters
IF a$ = "1" THEN INPUT "Instructions  "; b$: GOTO parseinp
IF a$ = "2" THEN INPUT "Modifiers  "; b$: GOTO parseinp
IF a$ = "3" THEN INPUT "Address modes  "; b$: GOTO parseinp
GOTO modin1
parseinp:
b$ = RTRIM$(LTRIM$(b$))
IF b$ = "" THEN
 IF a$ = "2" THEN nmod = 0
 GOTO instructoptions
END IF
IF a$ = "1" THEN FOR i = 1 TO maxnins: instructs$(i) = "   ": NEXT i
IF a$ = "2" THEN FOR i = 1 TO maxnmod: modifiers$(i) = "  ": NEXT i
IF a$ = "3" THEN FOR i = 1 TO maxnadr: adrmodes$(i) = " ": NEXT i
j = 1: k = 1
FOR i = 1 TO LEN(b$)
 IF MID$(b$, i, 1) = " " THEN
  IF i < LEN(b$) AND MID$(b$, i + 1, 1) <> " " THEN j = 1: k = k + 1
 ELSE
  IF a$ = "1" THEN c$ = instructs$(k)
  IF a$ = "2" THEN c$ = modifiers$(k)
  IF a$ = "3" THEN c$ = adrmodes$(k)
  MID$(c$, j, 1) = MID$(b$, i, 1): j = j + 1
  IF a$ = "1" THEN instructs$(k) = c$
  IF a$ = "2" THEN modifiers$(k) = c$
  IF a$ = "3" THEN adrmodes$(k) = c$
 END IF
NEXT i
IF a$ = "1" THEN nins = k
IF a$ = "2" THEN nmod = k
IF a$ = "3" THEN nadr = k
GOTO instructoptions

otheroptions:
CLS : PRINT
PRINT "   A) Local number chance    "; localnum
PRINT "   B) Local chance varience  "; localvar
PRINT "   C) Chance of data change  "; datachange
PRINT "   D) Chance of size change  "; sizechange
PRINT "   E) Chance of addr change  "; adrchange
PRINT "   F) Chance of inst change  "; instrchange
PRINT "   G) Rounds per battle      "; rounds
PRINT "   H) Max warrior length     "; maxlen
PRINT "   I) Max instruction cycles "; cycles
PRINT "   J) Max processes          "; processes
PRINT "   K) Core size              "; coresize
PRINT "   L) Grid size (restarts)   "; gridsize
PRINT "   M) PMARS base comline      "; pmars$
PRINT "   N) PMARSV base comline     "; pmarsv$
PRINT "   O) Test PMARS comline      "; mtpmars$
PRINT "   P) Graphics mode parm      "; grmode$
PRINT "   Q) Text mode parm          "; txmode$
PRINT "   R) Double battle fixed     ";
IF twiceopt = 0 THEN PRINT "Off" ELSE PRINT "On"
PRINT "   S) Mix courseness         "; mixcourseness
PRINT "   T) Adjust local refs       ";
IF adjustrefs = 0 THEN PRINT "No"
IF adjustrefs = 1 THEN PRINT "Yes"
IF adjustrefs = 2 THEN PRINT "Sometimes"
PRINT
othopt1:
LOCATE 23, 1: PRINT "   Press Esc when done"  '3-28-01
othopt2:
a$ = INKEY$: IF a$ = "" GOTO othopt2
LOCATE 23, 1: PRINT "                      ": LOCATE 23, 1
IF a$ = CHR$(27) GOTO parameters
IF a$ = "a" THEN INPUT "Local chance (0-1)"; localnum: GOTO otheroptions
IF a$ = "b" THEN INPUT "Local varience (0-1)"; localvar: GOTO otheroptions
IF a$ = "c" THEN INPUT "Data chance (0-1)"; datachange: GOTO otheroptions
IF a$ = "d" THEN INPUT "Size chance (0-1)"; sizechange: GOTO otheroptions
IF a$ = "e" THEN INPUT "Addr chance (0-1)"; adrchange: GOTO otheroptions
IF a$ = "f" THEN INPUT "Inst chance (0-1)"; instrchange: GOTO otheroptions
IF a$ = "g" THEN INPUT "Battle rounds (max 33)"; rounds: GOTO otheroptions
IF a$ = "h" THEN INPUT "Max warrior length"; maxlen: GOTO otheroptions
IF a$ = "i" THEN INPUT "Max instruction cycles"; cycles: GOTO otheroptions
IF a$ = "j" THEN INPUT "Max processes"; processes: GOTO otheroptions
IF a$ = "k" THEN INPUT "Coresize"; coresize: GOTO otheroptions
IF a$ = "l" THEN
 INPUT "Grid size (4-21)"; g
 IF g < 4 OR g > 21 GOTO otheroptions
 gridsize = g: GOSUB savesettings
 IF baddata GOTO baddatamessage
 rerun = 1: GOTO getoutofhere
END IF
IF a$ = "m" THEN INPUT "PMARS base comline"; pmars$: GOTO otheroptions
IF a$ = "n" THEN INPUT "PMARSV base comline"; pmarsv$: GOTO otheroptions
IF a$ = "o" THEN INPUT "Test PMARS comline"; mtpmars$: GOTO otheroptions
IF a$ = "p" THEN INPUT "Graphics mode parm"; grmode$: GOTO otheroptions
IF a$ = "q" THEN INPUT "Text mode parm"; txmode$: GOTO otheroptions
IF a$ = "r" THEN
 IF twiceopt = 0 THEN twiceopt = 1 ELSE twiceopt = 0
 GOTO otheroptions
END IF
IF a$ = "s" THEN INPUT "Mix courseness"; mixcourseness: GOTO otheroptions
IF a$ = "t" THEN
 adjustrefs = adjustrefs + 1: IF adjustrefs > 2 THEN adjustrefs = 0
 GOTO otheroptions
END IF
GOTO othopt1

savesettings:
GOSUB validatedata
IF baddata THEN RETURN
OPEN reddefs$ FOR OUTPUT AS #1
PRINT #1, minscore
PRINT #1, maxscore
PRINT #1, adjrate
PRINT #1, remloser
PRINT #1, change
PRINT #1, perfect
PRINT #1, tragedy
PRINT #1, rounds
PRINT #1, usegraphics
PRINT #1, mtrounds
PRINT #1, mtmask$
PRINT #1, teststart
PRINT #1, testbirth
PRINT #1, testdelay
PRINT #1, testscore
PRINT #1, testrounds
PRINT #1, testwar$
PRINT #1, startdensity
PRINT #1, nins
FOR i = 1 TO nins: PRINT #1, instructs$(i): NEXT i
PRINT #1, nmod
IF nmod > 0 THEN FOR i = 1 TO nmod: PRINT #1, modifiers$(i): NEXT i
PRINT #1, nadr
FOR i = 1 TO nadr: PRINT #1, adrmodes$(i): NEXT i
PRINT #1, localnum
PRINT #1, localvar
PRINT #1, datachange
PRINT #1, sizechange
PRINT #1, adrchange
PRINT #1, instrchange
PRINT #1, gridsize
PRINT #1, maxlen
PRINT #1, coresize
PRINT #1, cycles
PRINT #1, processes
PRINT #1, pmars$
PRINT #1, pmarsv$
PRINT #1, mtpmars$
PRINT #1, grmode$
PRINT #1, txmode$
PRINT #1, twiceopt
PRINT #1, replaceloser
PRINT #1, extrainfo
PRINT #1, enableredmix
PRINT #1, mixcourseness
PRINT #1, coreview
PRINT #1, colorby
PRINT #1, autostart
PRINT #1, wardir$
PRINT #1, adjustrefs
PRINT #1, enreintro
PRINT #1, savethresh
PRINT #1, reintrochance
PRINT #1, savedir$
PRINT #1, savelimit
CLOSE #1
RETURN

validatedata:
baddata = 0
IF gridsize < 4 OR gridsize > 21 THEN baddata = 1
IF wardir$ = "" OR mtmask$ = "" OR testwar$ = "" THEN baddata = 1
IF maxlen < 1 OR maxlen > 100 THEN baddata = 1
IF nins < 1 OR nmod < 0 OR nadr < 1 THEN baddata = 1
IF rounds < 1 OR rounds > 33 THEN baddata = 1
IF testrounds < 1 OR testrounds > 33 THEN baddata = 1
IF teststart <> 0 AND teststart <> 1 THEN baddata = 1
IF testbirth <> 0 AND testbirth <> 1 THEN baddata = 1
IF usegraphics <> 0 AND usegraphics <> 1 THEN baddata = 1
IF remloser <> 0 AND remloser <> 1 THEN baddata = 1
IF replaceloser <> 0 AND replaceloser <> 1 THEN baddata = 1
IF localnum < 0 OR localnum > 1 THEN baddata = 1
IF datachange < 0 OR datachange > 1 THEN baddata = 1
IF sizechange < 0 OR sizechange > 1 THEN baddata = 1
IF adrchange < 0 OR adrchange > 1 THEN baddata = 1
IF instrchange < 0 OR instrchange > 1 THEN baddata = 1
IF change < 0 OR change > 1 THEN baddata = 1
IF tragedy < 0 OR tragedy > 1 THEN baddata = 1
IF perfect < 0 OR perfect > 1 THEN baddata = 1
IF maxscore < minscore OR minscore < 0 OR maxscore > 300 THEN baddata = 1
IF testscore < 0 OR testscore > 300 THEN baddata = 1
IF coresize < 40 OR cycles < 40 OR processes < 1 THEN baddata = 1
IF pmars$ = "" OR pmarsv$ = "" OR mtpmars$ = "" THEN baddata = 1
IF extrainfo < 0 OR extrainfo > 2 THEN baddata = 1
IF enableredmix < 0 OR enableredmix > 2 THEN baddata = 1
IF mixcourseness <= 0 THEN baddata = 1
IF coreview < 0 OR coreview > 5 THEN baddata = 1
IF colorby <> 0 AND colorby <> 1 THEN baddata = 1
IF autostart <> 0 AND autostart <> 1 THEN baddata = 1
IF adjustrefs < 0 OR adjustrefs > 2 THEN baddata = 1
wardir$ = LTRIM$(RTRIM$(wardir$)): IF wardir$ = "" THEN baddata = 1
savedir$ = LTRIM$(RTRIM$(savedir$)): IF savedir$ = "" THEN baddata = 1
IF reintrochance < 0 OR reintrochance > .1 THEN baddata = 1
IF savethresh < 2 THEN baddata = 1
IF savelimit < 0 THEN baddata = 1
RETURN

' write iteration count and exit
getoutofhere:
CLS
ON ERROR GOTO getout1
KILL "score$.out": OPEN wardir$ + "\" + savefile$ FOR OUTPUT AS #1
PRINT #1, iteration&: PRINT #1, mss
getout1:
CLOSE #1
IF rerun THEN RUN
SYSTEM

' create new population
initstart:
ON ERROR GOTO initerror
SHELL "md " + wardir$
COLOR 7, 0: CLS : PRINT : PRINT
COLOR 4, 0: PRINT " "; progid$: PRINT " "; copyrt$
COLOR 7, 0: PRINT
IF isx + isy = 2 THEN PRINT " Create";  ELSE PRINT " Continue creating";
PRINT " starting population? (Y/N)"
k$ = "": WHILE k$ <> "y" AND k$ <> "n": k$ = LCASE$(INKEY$): WEND
IF k$ = "n" GOTO startevol
CLS : PRINT : PRINT : COLOR 4, 0: PRINT " "; progid$: COLOR 7, 0: PRINT
IF isx + isy = 2 THEN PRINT " Creating new warrior population..."
IF isx + isy > 2 THEN PRINT " Continuing warrior creation..."
IF teststart THEN
 PRINT : PRINT " Testing each warrior for operation, can take awhile!"
 PRINT " Avoid the keyboard - pmars goes debug without a prompt."
 PRINT " To continue, backspace key(s) then press "; CHR$(34); "c"; CHR$(34); " and enter."
 PRINT " Control-c to quit, will restart on next run."
END IF
FOR x = 1 TO gridsize
 FOR y = 1 TO gridsize
  IF isx > 1 OR isy > 1 THEN x = isx: y = isy: isx = 1: isy = 1
  IF RND > startdensity GOTO initnext
  LOCATE 12, 2: PRINT "Working on warrior"; x; ","; y; "    "
  zname$ = CHR$(x + 64) + CHR$(y + 96)
  redfile$ = wardir$ + "\" + zname$ + ".red"
  zname$ = zname$ + zname$
makerndwarrior:
  localchance = localnum + ((RND - .5) * localvar)
  OPEN redfile$ FOR OUTPUT AS #1
  warlen = INT(RND * maxlen) + 1
  PRINT #1, ";RedMaker Warrior"
  PRINT #1, ";name "; zname$
  PRINT #1, ";assert 1"
  FOR ln = 1 TO warlen
   GOSUB makerndwarline: PRINT #1, warline$
  NEXT ln: PRINT #1, "end"
'8/30/00 stats comments...
  IF extrainfo > 0 THEN  '3-4-01
   PRINT #1, ";origin random start";
   IF teststart THEN PRINT #1, " (pre-tested)";
   PRINT #1, "": PRINT #1, ";generation 0"
   PRINT #1, ";iteration 0"
   IF extrainfo = 2 THEN
    PRINT #1, ";battles 0"
    PRINT #1, ";score 0"
   END IF
  END IF
  CLOSE #1
'if defined, battle new warrior against test warrior
  IF teststart = 0 GOTO initnext
  cl$ = pmars$ + " -r" + STR$(testrounds) + " -s" + STR$(coresize)
  cl$ = cl$ + " -c" + STR$(cycles) + " -p" + STR$(processes)
  cl$ = cl$ + " " + redfile$ + " " + testwar$ + ">score$.out"
  SHELL cl$
  ON ERROR GOTO initerror  'fix restart bug in compiled version (???)
  OPEN "score$.out" FOR INPUT AS #1
  INPUT #1, a$: INPUT #1, b$: INPUT #1, c$: CLOSE #1
  myscore = INT(VAL(RIGHT$(a$, 2)) * (100 / testrounds))
' if score too try again
  IF myscore < testscore GOTO makerndwarrior
' do next member
initnext:
 NEXT y
NEXT x
' reset save file
OPEN wardir$ + "\" + savefile$ FOR OUTPUT AS #1
PRINT #1, 0: PRINT #1, mss: CLOSE #1

' right to here if warriors exist
startevol:

'check for data file
ON ERROR GOTO nodatafile
OPEN wardir$ + "\" + savefile$ FOR INPUT AS #1
INPUT #1, iteration&: INPUT #1, mss
cdfdone:
CLOSE #1

' ignore test delay if warriors were born tested
IF testbirth = 1 AND teststart = 1 THEN dobirthchecks = 1

' menu if autostart = 0
IF autostart = 0 GOTO menu

' reenter evolution loop
evolve:
ON ERROR GOTO menuerror
'v2.9 features 9-16-01..
'make sure save directory exists (if extrainfo = 2)
IF extrainfo = 2 AND enreintro <> 0 THEN
 SHELL "if not exist " + savedir$ + "\*.* md " + savedir$
END IF
'create del2stop file
IF stopcheck > 0 THEN
 OPEN "del2stop" FOR OUTPUT AS #5
 PRINT #5, "Delete this file to stop RedMaker"
 CLOSE #5
END IF
GOSUB plotwarriors
COLOR 4, 0: LOCATE 3, txto: PRINT progid$
COLOR 6, 0: LOCATE 16, txto: PRINT "Control-c for menu"
LOCATE 17, txto: PRINT "Any key to crash"

evolveloop:
IF iteration& > testdelay AND testbirth <> 0 THEN dobirthchecks = 1
COLOR 7, 0
LOCATE 12, txto: PRINT "Iteration"; iteration&
LOCATE 13, txto: PRINT "Min survival ="; mss
IF testbirth <> 0 THEN
 LOCATE 14, txto: PRINT "Evaluation ";
 IF dobirthchecks = 0 THEN PRINT "disabled" ELSE PRINT "enabled "
END IF

'check for del2stop file every now and then
IF stopcheck > 0 THEN
 IF iteration& MOD stopcheck = 0 THEN
  ON ERROR GOTO fswnoscore  'same code as stopping via ctrl-c
  OPEN "del2stop" FOR INPUT AS #5
  CLOSE #5
 END IF
END IF

'if extrainfo = 2 then randomly reintoduce saved warriors according
'to reintrochance, every now and then prune save directory  9-16-01
ON ERROR GOTO menuerror
IF extrainfo = 2 AND enreintro <> 0 THEN
 IF RND(1) < reintrochance THEN
  GOSUB reintroduce  'select, reintroduce and update display/arrays
 END IF
 'if savelimit set, check iteration count and if time prune save dir
 '12/27/04 but only if something has been saved 1st in current run
 IF savelimit > 0 THEN
  IF iteration& MOD pruneiter = 0 AND somethingthere <> 0 THEN
   'get dir count
   SHELL "dir /-p /b " + savedir$ + "\*.red > savedir$.tmp"
   OPEN "savedir$.tmp" FOR INPUT AS #5
   n = 0
   WHILE NOT EOF(5)
    LINE INPUT #5, sf$: n = n + 1
   WEND
   CLOSE #5
   IF n > savelimit THEN
    'randomly delete excess
    z = n - savelimit
    FOR i = 1 TO z
     r = INT(RND(1) * n) + 1
     OPEN "savedir$.tmp" FOR INPUT AS #5
     FOR j = 1 TO r: LINE INPUT #5, sf$: NEXT j
     CLOSE #5
     KILL savedir$ + "\" + sf$
     SHELL "dir /-p /b " + savedir$ + "\*.red > savedir$.tmp"
     n = n - 1
    NEXT i
   END IF
   KILL "savedir$.tmp"
  END IF
 END IF
END IF

COLOR 7, 0: LOCATE 18, txto

' find a warrior at a random location
fragain:
' an out if everything dies
IF INKEY$ <> "" GOTO menu
x = INT(RND * gridsize) + 1: y = INT(RND * gridsize) + 1
redfile$ = wardir$ + "\" + CHR$(x + 64) + CHR$(y + 96) + ".red"
ON ERROR GOTO frnowar
OPEN redfile$ FOR INPUT AS #1
INPUT #1, a$: INPUT #1, nameline$
'8/26/00 2.82.. get warrior stats
IF extrainfo THEN
 generation = 0: origin$ = "unknown"
 WHILE EOF(1) = 0
  LINE INPUT #1, a$
  IF LEFT$(a$, 8) = ";origin " THEN origin$ = RIGHT$(a$, LEN(a$) - 8)
  IF LEFT$(a$, 12) = ";generation " THEN
   generation = VAL(RIGHT$(a$, LEN(a$) - 12))
  END IF
 WEND
END IF
CLOSE #1: GOTO frok
frnowar:
CLOSE #1: RESUME fragain
frok:
zname$ = MID$(nameline$, 7, 4)
' check surrounding area for a warrior to battle
direction = INT(RND * 8): GOSUB getnewxy: x1 = nx: y1 = ny
' form filename and try to open
opponent$ = wardir$ + "\" + CHR$(x1 + 64) + CHR$(y1 + 96) + ".red"
ON ERROR GOTO fsnowar
OPEN opponent$ FOR INPUT AS #1
INPUT #1, a$: INPUT #1, a$: CLOSE #1: GOTO fswar
fsnowar:
CLOSE #1: RESUME fsreproduce

' if it's a warrior, do battle
fswar:
opzname$ = MID$(a$, 7, 4)
LOCATE 5, txto: PRINT zname$; " vs. "; opzname$; "    ": LOCATE 18, txto
'** new option 8/16/00 - battle twice pos's reversed using fixed sequence
IF twiceopt = 0 THEN
'original code...
 cl$ = pmars$ + " -r" + STR$(rounds) + " -s" + STR$(coresize)
 cl$ = cl$ + " -c" + STR$(cycles) + " -p" + STR$(processes)
 cl$ = cl$ + " " + redfile$ + " " + opponent$ + ">score$.out"
 ON ERROR GOTO fswnoscore
 SHELL cl$: OPEN "score$.out" FOR INPUT AS #1
 INPUT #1, a$: INPUT #1, b$: INPUT #1, c$: CLOSE #1
 myscore = INT(VAL(RIGHT$(a$, 2)) / (rounds / 100)) 'valid if rounds <= 33
 opscore = INT(VAL(RIGHT$(b$, 2)) / (rounds / 100))
ELSE
'new code...
 cl$ = pmars$: IF INSTR(LCASE$(pmars$), "-f") = 0 THEN cl$ = cl$ + " -f"
 cl$ = pmars$ + " -r" + STR$(rounds) + " -s" + STR$(coresize)
 cl$ = cl$ + " -c" + STR$(cycles) + " -p" + STR$(processes)
 ON ERROR GOTO fswnoscore
 SHELL cl$ + " " + redfile$ + " " + opponent$ + ">score$.out"
 OPEN "score$.out" FOR INPUT AS #1
 INPUT #1, a$: INPUT #1, b$: INPUT #1, c$: CLOSE #1
 myscore = INT(VAL(RIGHT$(a$, 2)) / (rounds / 100))
 opscore = INT(VAL(RIGHT$(b$, 2)) / (rounds / 100))
 SHELL cl$ + " " + opponent$ + " " + redfile$ + ">score$.out"
 OPEN "score$.out" FOR INPUT AS #1
 INPUT #1, a$: INPUT #1, b$: INPUT #1, c$: CLOSE #1
 myscore = INT((myscore + INT(VAL(RIGHT$(b$, 2)) / (rounds / 100))) / 2)
 opscore = INT((opscore + INT(VAL(RIGHT$(a$, 2)) / (rounds / 100))) / 2)
END IF
LOCATE 6, txto: PRINT zname$; " scores"; myscore; "     "
LOCATE 7, txto: PRINT opzname$; " scores"; opscore; "     "
'update age and score of both warriors - new 8/26/00
IF extrainfo = 2 THEN   'process age/score comments of combatants
 f$ = redfile$: s = myscore: GOSUB updateage
 warscore%(x, y) = avgscore  '9-16-01
 f$ = opponent$: s = opscore: GOSUB updateage
END IF
'new 3-3-01 update battles
'inc both, loser will be deleted
warbattles%(x, y) = warbattles%(x, y) + 1
warbattles%(x1, y1) = warbattles%(x1, y1) + 1
x2 = x: y2 = y: zn2$ = LEFT$(zname$, 2): GOSUB printwarlabel
x2 = x1: y2 = y1: zn2$ = LEFT$(opzname$, 2): GOSUB printwarlabel
COLOR 7, 0
'
vacated = 0  'more new stuff 8/19/00
' remove loser or if below min survival score
IF (opscore < myscore AND remloser = 1) OR opscore < mss THEN
 f$ = opponent$: x2 = x1: y2 = y1
 n$ = opzname$: GOSUB killwarrior: vacated = 1
END IF
IF (myscore < opscore AND remloser = 1) OR myscore < mss THEN
 f$ = redfile$: x2 = x: y2 = y
 n$ = zname$: GOSUB killwarrior: vacated = 0
END IF
'if replaceloser option enabled, replicate to vacated position
IF replaceloser THEN
 IF vacated GOTO fsreproduce 'replicate to file in opponent$
END IF

' (if still here) sometimes remove ties
IF opscore = myscore AND opscore >= mss THEN
 f$ = redfile$: x2 = x: y2 = y: n$ = zname$
 IF RND < tragedy THEN GOSUB killwarrior
 f$ = opponent$: x2 = x1: y2 = y1: n$ = opzname$
 IF RND < tragedy THEN GOSUB killwarrior
END IF
'and continue
GOTO nextfight

'8/26/00 update age and average score
'filename in f$, last score in s
'9-16-01 leave average score in avgscore, copy survivors to warsave dir
'9-21 consistent temp name, reporting
updateage:
OPEN f$ FOR INPUT AS #1
OPEN wardir$ + "\tempwar.r" FOR OUTPUT AS #2
WHILE EOF(1) = 0
 LINE INPUT #1, a$
 IF LEFT$(a$, 9) = ";battles " THEN
  battles = VAL(RIGHT$(a$, LEN(a$) - 9))
  PRINT #2, ";battles"; battles + 1
 ELSE
  IF LEFT$(a$, 7) = ";score " THEN
   total = VAL(RIGHT$(a$, LEN(a$) - 7)) * battles + s
   avgscore = INT(total / (battles + 1))
   PRINT #2, ";score"; avgscore
  ELSE
   PRINT #2, a$
  END IF
 END IF
WEND: CLOSE
KILL f$: NAME wardir$ + "\tempwar.r" AS f$
'copy warrior to savedir$ if survives savethresh battles
IF enreintro THEN
 IF battles + 1 >= savethresh THEN
  LOCATE 10, txto: PRINT "Keeping "; RIGHT$(LCASE$(f$), 6); "   "
  SHELL "copy " + f$ + " " + savedir$ + ">nul"
  somethingthere = 1 '12/27/04 make sure it saves before restoring
 END IF
END IF
RETURN

' if opponent doesn't exist produce a varient
fsreproduce:
ON ERROR GOTO reproerror
localchance = localnum + ((RND - .5) * localvar)
newzname$ = LEFT$(zname$, 2) + CHR$(x1 + 64) + CHR$(y1 + 96)
' determine warrior size
warlen = 0: OPEN redfile$ FOR INPUT AS #1
LINE INPUT #1, a$: LINE INPUT #1, a$: LINE INPUT #1, a$
reprods:
LINE INPUT #1, a$
IF a$ <> "end" THEN warlen = warlen + 1: GOTO reprods
CLOSE #1: OPEN redfile$ FOR INPUT AS #1
LINE INPUT #1, a$: LINE INPUT #1, a$: LINE INPUT #1, a$
' open outfile and write headers
OPEN opponent$ FOR OUTPUT AS #2
PRINT #2, ";RedMaker Warrior"
PRINT #2, ";name "; newzname$
PRINT #2, ";assert 1"
ln = 0: pc = 0: IF RND < perfect THEN pc = 1

'from an old experiment - updated 8/29/00
' if mix enabled and partner exists, open it as 3 and set mixred = 1
'3-4-01 if enableredmix = 2 then disables species check, mix anything
mixred = 0: mixed = 0: mixedwith = 0
strangecode = 0 'note non-species code in warrior comments
adjustdata = 0: ipoint = 0 '3-28-01 how much to adjust refs after insertion
IF enableredmix > 0 AND pc = 0 THEN
 ON ERROR GOTO fsnomate
' mixsource = INT(RND * 2) 'random pick for start
 mixsource = 0        'main parent starts first  3-4-01
 chanceofswitch = 1 / (warlen * mixcourseness)
 direction = INT(RND * 8): GOSUB getnewxy
 mate$ = wardir$ + "\" + CHR$(nx + 64) + CHR$(ny + 96) + ".red"
 IF mate$ <> opponent$ AND mate$ <> redfile$ THEN
  OPEN mate$ FOR INPUT AS #3
  IF extrainfo THEN
   WHILE EOF(3) = 0: LINE INPUT #3, a$
   IF LEFT$(a$, 12) = ";generation " THEN
    mixedwith = VAL(RIGHT$(a$, LEN(a$) - 12))
   END IF
   WEND: CLOSE #3: OPEN mate$ FOR INPUT AS #3
  END IF
  LINE INPUT #3, a$: LINE INPUT #3, a$
  IF MID$(a$, 7, 2) = LEFT$(newzname$, 2) OR enableredmix = 2 THEN '3-4-01
    mixred = 1: matename$ = MID$(a$, 7, 4)
    IF LEFT$(matename$, 2) <> LEFT$(newzname$, 2) THEN strangecode = 1
    LINE INPUT #3, a$
  END IF
 END IF
END IF
GOTO reproloop
fsnomate:
CLOSE #3: RESUME reproloop

reproloop:
ON ERROR GOTO reproerror
ln = ln + 1: LINE INPUT #1, myline$
IF myline$ = "end" GOTO reprodone
IF pc = 1 GOTO reprowl  'make perfect copy, don't bother w/cross
'8/28/00 crude crossover.. file already open as #3
IF mixred THEN
 LINE INPUT #3, mateline$              'keep position with other parent
 IF mateline$ = "end" THEN mixred = 0  'terminate mixing if at end of other
 IF mixred THEN                        'if not at end...
  IF RND < chanceofswitch THEN mixsource = 1 - mixsource
  IF mixsource THEN myline$ = mateline$: mixed = 1
 END IF
END IF
IF RND > change GOTO reprowl  ' no change in line
' add, delete and alter various things
what = INT(RND * 8) + 1
' second chances to not change
IF what = 3 OR what = 4 THEN IF RND > instrchange GOTO reprowl
IF what = 6 OR what = 8 THEN IF RND > datachange GOTO reprowl
IF what = 5 OR what = 7 THEN IF RND > adrchange GOTO reprowl
IF what = 1 OR what = 2 THEN IF RND > sizechange GOTO reprowl
' change selected thing
ON what GOTO addline, delline, chinst, chmod, chadr1, chconst1, chadr2, chconst2

addline:
IF warlen = maxlen GOTO reprowl
IF adjustrefs > 0 THEN adjustdata = 1: GOSUB AdjustWarRefs '3-28
GOSUB makerndwarline: PRINT #2, warline$
ln = ln + 1: warlen = warlen + 1
GOTO reprowl

AdjustWarRefs: '3-28-01
'when adding/deleting lines, inc/dec previous local refs
'that refer after the insertion.. argh!! have to close the
'partial file, fix data, then reopen for append as nothing happened..
 IF adjustrefs = 2 THEN IF RND > .5 THEN RETURN  'sometimes if 2
 ipoint = ln: CLOSE #2: OPEN opponent$ FOR INPUT AS #2
 rl = 0: nn$ = LEFT$(opponent$, LEN(opponent$) - 2)
 OPEN nn$ FOR OUTPUT AS #4
 WHILE NOT EOF(2) 'loop through partial results
  LINE INPUT #2, aa$
  IF LEFT$(aa$, 1) <> ";" AND MID$(aa$, 14, 1) = "," THEN 'if redcode line
   rl = rl + 1  'count redcode lines (ln is insertion line)
   d1 = VAL(MID$(aa$, 9, 5)): d2 = VAL(MID$(aa$, 17))
   IF d1 < (warlen - rl) AND d1 >= (ln - rl) THEN d1 = d1 + adjustdata
   IF d2 < (warlen - rl) AND d2 >= (ln - rl) THEN d2 = d2 + adjustdata
   MID$(aa$, 9, 5) = STR$(d1): MID$(aa$, 17) = STR$(d2)
  END IF
  PRINT #4, aa$
 WEND
 CLOSE #4: CLOSE #2
 KILL opponent$: NAME nn$ AS opponent$ 'rename back
 OPEN opponent$ FOR APPEND AS #2  'back to where it was
RETURN

delline:
IF warlen = 1 GOTO reprowl
IF adjustrefs > 0 THEN adjustdata = -1: GOSUB AdjustWarRefs '3-28
warlen = warlen - 1: ln = ln - 1: GOTO reproloop
chinst:
MID$(myline$, 1, 3) = instructs$(INT(RND * nins) + 1): GOTO reprowl
chmod:
IF nmod = 0 OR MID$(myline$, 4, 1) <> "." GOTO reprowl
MID$(myline$, 5, 2) = modifiers$(INT(RND * nmod) + 1) + " ": GOTO reprowl
chadr1:
MID$(myline$, 8, 1) = adrmodes$(INT(RND * nadr) + 1): GOTO reprowl
chadr2:
MID$(myline$, 16, 1) = adrmodes$(INT(RND * nadr) + 1): GOTO reprowl
chconst1:
IF RND < localchance THEN
 n = INT(RND * warlen) - ln + 1
ELSE
 n = INT(RND * coresize)
END IF
MID$(myline$, 9, 5) = LEFT$(STR$(n) + "   ", 5): GOTO reprowl
chconst2:
IF RND < localchance THEN
 n = INT(RND * warlen) - ln + 1
ELSE
 n = INT(RND * coresize)
END IF
MID$(myline$, 17, 5) = LEFT$(STR$(n) + "   ", 5)

' write new warrior line, changed or not
reprowl:
IF adjustrefs > 0 AND adjustdata <> 0 THEN
'3-28-01 alter data if insertion or deletion
 IF adjustrefs <> 2 OR RND <= .5 THEN  'sometimes if 2
  IF LEFT$(myline$, 1) <> ";" AND MID$(myline$, 14, 1) = "," THEN
   d1 = VAL(MID$(myline$, 9, 5)): d2 = VAL(MID$(myline$, 17))
   IF d1 <= (ipoint - ln) THEN d1 = d1 - adjustdata
   IF d2 <= (ipoint - ln) THEN d2 = d2 - adjustdata
   MID$(myline$, 9, 5) = STR$(d1): MID$(myline$, 17) = STR$(d2)
  END IF
 END IF
END IF
PRINT #2, myline$: GOTO reproloop
reprodone:
PRINT #2, "end"
'8/30/00 write stats to warrior
IF extrainfo THEN
'3-4-01 need a way to notate mixed-species warriors..
 IF strangecode > 0 AND mixed > 0 THEN
'trying to account for multiple mixing will result in hopeless confusion
'so check origin var.. if it already contains "mixed with" come up with
'a new name.. vain attempt at making it make sense...
  z = INSTR(origin$, " mixed with ")
  IF z > 0 THEN
   IF LEFT$(origin$, 6) = "mixed " THEN   'avoid mixed mixed ...
    origin$ = MID$(origin$, 7): z = z - 6
   END IF
   IF z > 0 THEN
    origin$ = "mixed " + LEFT$(origin$, z - 1)
   ELSE
    origin$ = "mixed " + LEFT$(newzname$, 2) + " species"
   END IF
  ELSE
'if strangecode is true then #3 is still open for read,
'snag partner's origin line..
   mateorigin$ = "unknown " + LEFT$(matename$, 2) + " species"
   WHILE NOT EOF(3)
    LINE INPUT #3, a$
    IF LEFT$(a$, 8) = ";origin " THEN mateorigin$ = MID$(a$, 9)
   WEND
   origin$ = LTRIM$(RTRIM$(origin$))
   mateorigin$ = LTRIM$(RTRIM$(mateorigin$))
   origin$ = LEFT$(origin$, 25) + " mixed with " + LEFT$(mateorigin$, 25)
  END IF
 END IF
'
 PRINT #2, ";origin "; origin$
 newgen = generation + 1
 IF extrainfo = 2 THEN
  IF mixed THEN
   PRINT #2, ";parents "; zname$; " ("; LTRIM$(RTRIM$(STR$(generation)));
   PRINT #2, ") and "; matename$; " ("; LTRIM$(RTRIM$(STR$(mixedwith))); ")"
  ELSE
   PRINT #2, ";parent "; zname$; " ("; LTRIM$(RTRIM$(STR$(generation))); ")"
  END IF
 END IF
 PRINT #2, ";generation"; newgen  'one more than oldest
 PRINT #2, ";iteration"; iteration&
 IF extrainfo = 2 THEN
  PRINT #2, ";battles 0"
  PRINT #2, ";score 0"
 END IF
END IF
CLOSE

'if defined, test new warrior against a test warrior
IF dobirthchecks = 0 GOTO updatedisplay
cl$ = pmars$ + " -r" + STR$(testrounds) + " -s" + STR$(coresize)
cl$ = cl$ + " -c" + STR$(cycles) + " -p" + STR$(processes)
cl$ = cl$ + " " + opponent$ + " " + testwar$ + ">score$.out"
ON ERROR GOTO fswnoscore
SHELL cl$: OPEN "score$.out" FOR INPUT AS #1
INPUT #1, a$: INPUT #1, b$: INPUT #1, c$: CLOSE #1
myscore = INT(VAL(RIGHT$(a$, 2)) / (testrounds / 100))
' if score too low pretend it didn't happen
IF myscore < mss OR myscore < testscore THEN KILL opponent$: GOTO fragain

' update display for birth
updatedisplay:
LOCATE 9, txto: PRINT "Creating "; newzname$
grid$(x1, y1) = LEFT$(newzname$, 2)
warlength%(x1, y1) = warlen
warbattles%(x1, y1) = 0
warscore%(x1, y1) = 0
wargen%(x1, y1) = newgen
x2 = x1: y2 = y1: zn2$ = LEFT$(newzname$, 2)
GOSUB printwarlabel 'mods 3-3-01
COLOR 7, 0

' again and again...
nextfight:
iteration& = iteration& + 1
IF iteration& MOD adjrate = 0 THEN mss = mss + 1
IF mss > maxscore THEN mss = maxscore
GOTO evolveloop

' sub - get nx, ny from x y and direction
getnewxy:
IF direction = 0 THEN nx = x - 1: ny = y
IF direction = 2 THEN nx = x: ny = y - 1
IF direction = 4 THEN nx = x + 1: ny = y
IF direction = 6 THEN nx = x: ny = y + 1
IF direction = 1 THEN nx = x - 1: ny = y - 1
IF direction = 3 THEN nx = x + 1: ny = y - 1
IF direction = 5 THEN nx = x + 1: ny = y + 1
IF direction = 7 THEN nx = x - 1: ny = y + 1
' wraparound
IF nx < 1 THEN nx = gridsize
IF ny < 1 THEN ny = gridsize
IF nx > gridsize THEN nx = 1
IF ny > gridsize THEN ny = 1
RETURN

' sub - make one line of redcode  (ln=line number)
makerndwarline:
warline$ = "                     "
a$ = instructs$(INT(RND * nins) + 1)
IF nmod = 0 THEN
 a$ = a$ + "   "
ELSE
 a$ = a$ + "." + modifiers$(INT(RND * nmod) + 1)
END IF
MID$(warline$, 1, 6) = a$
MID$(warline$, 8, 1) = adrmodes$(INT(RND * nadr) + 1)
IF RND < localchance THEN
 n = INT(RND * warlen) - ln + 1
ELSE
 n = INT(RND * coresize)
END IF
MID$(warline$, 9, 5) = STR$(n)
MID$(warline$, 14, 1) = ","
MID$(warline$, 16, 1) = adrmodes$(INT(RND * nadr) + 1)
IF RND < localchance THEN
 n = INT(RND * warlen) - ln + 1
ELSE
 n = INT(RND * coresize)
END IF
MID$(warline$, 17, 5) = STR$(n): RETURN

' sub - remove file f$ and from display
killwarrior:
LOCATE 8, txto: PRINT "Removing "; n$: KILL f$
LOCATE y2 + 2, x2 * 2 + 2: PRINT "  "; : LOCATE 18, txto
grid$(x2, y2) = "  "
RETURN

' sub - draw frame and plot warriors
plotwarriors:
' draw border
LOCATE 1, 1, 0: CLS : COLOR 7, 0: PRINT : PRINT "  "; CHR$(201);
FOR i = 1 TO gridsize * 2: PRINT CHR$(205); : NEXT i
PRINT CHR$(187)
FOR i = 1 TO gridsize
 PRINT "  "; CHR$(186); SPACE$(gridsize * 2); CHR$(186)
NEXT i
PRINT "  "; CHR$(200);
FOR i = 1 TO gridsize * 2: PRINT CHR$(205); : NEXT i
PRINT CHR$(188);
' display warrior symbols
plotwar1:
FOR x = 1 TO gridsize
 FOR y = 1 TO gridsize
' check grid$ array, don't read unless necessary
  IF gridvalid THEN zname$ = grid$(x, y): GOTO gotname
  redfile$ = wardir$ + "\" + CHR$(x + 64) + CHR$(y + 96) + ".red"
  ON ERROR GOTO einowar
  OPEN redfile$ FOR INPUT AS #1
  INPUT #1, a$: INPUT #1, a$
  zname$ = MID$(a$, 7, 2)
  grid$(x, y) = zname$ 'save for later refresh
'
'3-3-01 (2.84) record more info in arrays (upd.9-16-01 v2.9)
  w% = 0: LINE INPUT #1, a$: LINE INPUT #1, a$
  WHILE NOT EOF(1) AND a$ <> "end"
   w% = w% + 1: LINE INPUT #1, a$
  WEND
  warlength%(x, y) = w%: w% = 0
  WHILE NOT EOF(1)
   LINE INPUT #1, a$
   IF LEFT$(a$, 9) = ";battles " THEN
    warbattles%(x, y) = VAL(MID$(a$, 10))
   END IF
   IF LEFT$(a$, 7) = ";score " THEN
    warscore%(x, y) = VAL(MID$(a$, 8))
   END IF
   IF LEFT$(a$, 12) = ";generation " THEN
    wargen%(x, y) = VAL(MID$(a$, 13))
   END IF
  WEND
  CLOSE #1
'
gotname:
  IF zname$ = "  " GOTO eicontinue
  zn2$ = zname$: x2 = x: y2 = y: GOSUB printwarlabel'3-3-01
  GOTO eicontinue
einowar:
  CLOSE #1: grid$(x, y) = "  ": RESUME eicontinue
eicontinue:
 NEXT y
NEXT x
gridvalid = 1: RETURN

'sub - check for test warrior, create if necessary
checktestwar:
'12/26/04 just make it if it doesn't exist...
ON ERROR GOTO notestwar
OPEN testwar$ FOR INPUT AS #1: GOTO gottestwar
notestwar:
CLOSE #1: RESUME maketestwar
maketestwar:
ON ERROR GOTO initerror
OPEN testwar$ FOR OUTPUT AS #1
PRINT #1, ";assert 1": FOR i = 1 TO testwarlen
PRINT #1, testwarline$(i): NEXT i
gottestwar:
CLOSE #1: RETURN

pressanykey:
PRINT : PRINT "       ---- press any key ----";
WHILE (INKEY$ = ""): WEND
RETURN

printwarlabel:
'2-char spec. name in zn2$ loc in x2 y2
LOCATE y2 + 2, x2 * 2 + 2
n1 = ASC(MID$(zn2$, 1, 1)): n2 = ASC(MID$(zn2$, 2, 1))
IF coreview = 1 THEN zn2$ = RIGHT$("0" + LTRIM$(STR$(warbattles%(x2, y2))), 2)
IF coreview = 2 THEN zn2$ = RIGHT$("0" + LTRIM$(STR$(warlength%(x2, y2))), 2)
IF coreview = 3 THEN zn2$ = LEFT$(RIGHT$("00" + LTRIM$(STR$(warscore%(x2, y2))), 3), 2)
IF coreview = 4 THEN zn2$ = RIGHT$("00" + LTRIM$(STR$(wargen%(x2, y2))), 2)
IF coreview = 5 THEN zn2$ = LEFT$(RIGHT$("0000" + LTRIM$(STR$(wargen%(x2, y2))), 4), 2)
IF colorby = 1 THEN n1 = ASC(MID$(zn2$, 1, 1)): n2 = ASC(MID$(zn2$, 2, 1))
IF colorby = 2 THEN n1 = 7: n2 = 0  'fixed coloring
c1 = n1 MOD 16: c2 = n2 MOD 8
IF c1 = c2 THEN c1 = (n1 + 1) MOD 8 + 8
COLOR c1, c2: PRINT zn2$;
RETURN

'reintroduce randomly selected saved warrior
reintroduce:
IF somethingthere = 0 THEN RETURN '12/27/04 avoid file not found error
SHELL "dir /-p /b " + savedir$ + "\*.red > savedir$.tmp"
OPEN "savedir$.tmp" FOR INPUT AS #5
de = 0
WHILE NOT EOF(5)
 LINE INPUT #5, sf$
 de = de + 1
WEND
CLOSE #5
IF de > 0 THEN
 n = INT(1 + RND(1) * de)
 OPEN "savedir$.tmp" FOR INPUT AS #5
 FOR i = 1 TO n
  LINE INPUT #5, sf$
 NEXT i
 CLOSE #5 'random pick in sf$
 LOCATE 10, txto: PRINT "Restoring "; LCASE$(sf$) '9-20-01
 SHELL "copy " + savedir$ + "\" + sf$ + " " + wardir$ + " >nul"
 gridvalid = 0: GOSUB plotwar1: COLOR 7, 0
END IF
KILL "savedir$.tmp"
RETURN

'end of qbasic program

